From debian:testing

# Required extensions for this project
# 

ENV DEBIAN_FRONTEND noninteractive
ENV INITRD No

RUN apt-get update && apt-get install -y \
    locales \
    netcat 

RUN echo "locales locales/default_environment_locale select fr_FR.UTF-8" | debconf-set-selections \
    && echo "locales locales/locales_to_be_generated multiselect 'fr_FR.UTF-8 UTF-8'" | debconf-set-selections \
    && echo "Europe/Paris" > /etc/timezone && dpkg-reconfigure -f noninteractive tzdata && locale-gen --purge en_US.UTF-8  \
    && rm -rf /var/lib/apt/lists/*

                                            
RUN apt-get update  \
    && apt-get upgrade -y \
    && apt-get --no-install-recommends --no-install-suggests -y  install \
        phpqrcode \
        imagemagick \
        nullmailer \
        bsd-mailx \
        ca-certificates \
        php7.3 \
        php7.3-bz2 \
        php7.3-fpm \
        php7.3-gd \
        php7.3-sqlite \
        php7.3-pgsql \
        php7.3-mysql \
        php7.3-xml \
        php7.3-xmlrpc \
        php7.3-curl \
        php7.3-common \
        php7.3-intl \
        php7.3-bcmath \
        php7.3-json \
        php7.3-mbstring \
        php-imagick \
        php7.3-zip \
        supervisor \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/* \
    && rm /var/log/dpkg.log

COPY ./etc/php /etc/php
COPY ./etc/nullmailer /etc/nullmailer
COPY ./etc/mailname /etc/mailname

RUN sed -i '/^listen /c listen = 0.0.0.0:9000' /etc/php/7.3/fpm/pool.d/www.conf && \
    mkdir -p /var/run/php && \
    ln -sf /dev/stdout /var/log/php7-fpm.log

EXPOSE 9000

VOLUME ["/var/www/spip", "/var/www/rainlop"]

CMD ["/usr/bin/supervisord"]

# CMD ["/usr/sbin/php-fpm7.3", "--nodaemonize"]
